	clear all
	clc	
	% Requirement for the bandstop filter
	wc1 = 20; wc2 = 40; ws1 = 15; ws2 = 55;
 	Amax = 0.28029; Amin = 40;
	if wc1*wc2 >= ws1*ws2;			% Modify band edges if necessary
		ws2 = wc1*wc2/ws1;
	else
		ws1 = wc1*wc2/ws2;
	end
	ws1
	ws2
	% Requirements for lowpass filter
	Omegac = wc2 - wc1; Omegas = ws2 - ws1; wI2 = wc1*wc2;
	
	% Synthesis of the lowpass filter (Cauer)
	NLP = CA_ORDER_S(Omegac, Omegas, Amax, Amin)
	NLP = floor(NLP)+1;	% Re-run after seting the filter order
	[GLP, ZLP, Zr, PLP, Wnew] = CA_POLES_S(Omegac, Omegas, Amax, Amin, NLP)
	
	% Transform the lowpass to a bandstop filter
	[Gbp, Zbp, Pbp] = PZ_2_G_SYM_BS_S(GLP, ZLP, PLP, wI2)
	figure(1)
	PLOT_PZ_S(Zbp, Pbp, 0,0, -60, 10, 80);
	alfa = linspace(pi/2, 3*pi/2, 200);
	plot(ws1*cos(alfa),ws1*sin(alfa),'-');
	plot(ws2*cos(alfa), ws2*sin(alfa),'-');
	
 	figure(2)
	W = [0:0.01:100]; axis([0 100 0 60]);
	H = PZ_2_FREQ_S(Gbp, Zbp, Pbp, W);
	Att = MAG_2_ATT(H);
	
	Taug = PZ_2_TG_S(Gbp, Zbp, Pbp, W);
	subplot('position', [0.08 0.4 0.80 0.5]);
	axis_Amax = 50; axis_Tg_max = 1;	
	PLOT_ATT_TG_S(Att, Taug, W, axis_Amax, axis_Tg_max);
	
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	text(45, 0.8,'Attenuation','FontName',fn,'FontSize',fs);
	text(20, 0.2,'Group Delay','FontName',fn,'FontSize',fs);
	
	
